<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

include 'db.php';
include 'authorization.php';
include 'functions.php';

// Get the raw POST data
$rawData = file_get_contents('php://input');

// Decode JSON data
$data = json_decode($rawData, true);

if (!$data) {
    echo json_encode(["message" => "Invalid JSON data received"]);
    exit();
}

// Validate required fields
if (empty($data['uID'])) {
    echo json_encode(["message" => "Missing required field: uID"]);
    exit();
}

$uID = $data['uID'];
$isLearner = $data['isLearner'];

if($isLearner==false || $isLearner=="false"){
    $query = "
    SELECT 
        u1.name AS user_name,
        u2.name AS learner_name,
        sd.test_result_id, 
        tr.learnerID, 
        sd.session_date,
        sd.session_day, 
        u1.city, 
        sd.slot_one, 
        sd.slot_two, 
        sd.slot_three, 
        u1.uID 
    FROM 
        session_details sd
    INNER JOIN 
        users u1 ON sd.uID = u1.uID 
    INNER JOIN 
        test_results tr ON tr.id = sd.test_result_id 
    INNER JOIN 
        users u2 ON tr.learnerID = u2.uID
    WHERE 
        u1.uID = '$uID' 
        AND (sd.accepted_one = 'Yes' OR sd.accepted_two = 'Yes' OR sd.accepted_three = 'Yes') AND STR_TO_DATE(sd.session_date, '%d-%m-%y') >= CURDATE()
    ORDER BY 
        sd.session_date ASC;
    ";
} else {
    $query = "
    SELECT 
        u1.name AS user_name,
        u2.name AS learner_name,
        sd.test_result_id, 
        tr.learnerID, 
        sd.session_date,
        sd.session_day, 
        u1.city, 
        sd.slot_one, 
        sd.slot_two, 
        sd.slot_three, 
        u1.uID 
    FROM 
        session_details sd
    INNER JOIN 
        users u1 ON sd.uID = u1.uID 
    INNER JOIN 
        test_results tr ON tr.id = sd.test_result_id 
    INNER JOIN 
        users u2 ON tr.learnerID = u2.uID
    WHERE 
        tr.learnerID = '$uID' 
        AND (sd.accepted_one = 'Yes' OR sd.accepted_two = 'Yes' OR sd.accepted_three = 'Yes') AND STR_TO_DATE(sd.session_date, '%d-%m-%y') >= CURDATE()
    ORDER BY 
        sd.session_date ASC;
    ";
}

$result = mysqli_query($conn, $query);
if (!$result) {
    echo json_encode(["message" => "Error executing query"]);
    exit();
}

$response = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $dateKey = $row["session_date"];
        
        if (!isset($response[$dateKey])) {
            $response[$dateKey] = [
                "Day" => $row["session_day"],
                "Date" => $dateKey,
                "isAvailable" => $isLearner == false || $isLearner == "false" ? true : null,
                "SlotOne" => null,
                "SlotTwo" => null,
                "SlotThree" => null,
            ];
        }
        
        if (!empty($row["slot_one"])) {
            $slot_one1 = $row["slot_one"];
            try {
                $slot_one1 = convert24HourTo12Hour($slot_one1);
            } catch (Exception $e) {}
            
            $response[$dateKey]["SlotOne"] = [
                "sessiontime" => $slot_one1,
                $isLearner == false || $isLearner == "false" ? "learnerName" : "instructorName" => $row[$isLearner == false || $isLearner == "false" ? "learner_name" : "user_name"],
            ];
        }

        if (!empty($row["slot_two"])) {
            $slot_two1 = $row["slot_two"];
            try {
                $slot_two1 = convert24HourTo12Hour($slot_two1);
            } catch (Exception $e) {}
            
            $response[$dateKey]["SlotTwo"] = [
                "sessiontime" => $slot_two1,
                $isLearner == false || $isLearner == "false" ? "learnerName" : "instructorName" => $row[$isLearner == false || $isLearner == "false" ? "learner_name" : "user_name"],
            ];
        }

        if (!empty($row["slot_three"])) {
            $slot_three1 = $row["slot_three"];
            try {
                $slot_three1 = convert24HourTo12Hour($slot_three1);
            } catch (Exception $e) {}
            
            $response[$dateKey]["SlotThree"] = [
                "sessiontime" => $slot_three1,
                $isLearner == false || $isLearner == "false" ? "learnerName" : "instructorName" => $row[$isLearner == false || $isLearner == "false" ? "learner_name" : "user_name"],
            ];
        }
    }
} else {
    $response["error"] = "No results found";
}

$response1 = [
    "message" => "Successful Message",
    "data" => array_values($response) // Send all the values in the response array
];

echo json_encode($response1);

mysqli_close($conn);
?>
