<?php
function convertTimeRange($timeRange) {
    // Split the input string into two parts: start time and end time
    list($startTime, $endTime) = explode(' to ', $timeRange);
    
    // Convert start time to 24-hour format
    $startDateTime = DateTime::createFromFormat('gA', $startTime);
    if (!$startDateTime) {
        throw new Exception("Failed to parse start time: $startTime");
    }
    $start24Hour = $startDateTime->format('H'); // Get hour in 24-hour format

    // Convert end time to 24-hour format
    $endDateTime = DateTime::createFromFormat('gA', $endTime);
    if (!$endDateTime) {
        throw new Exception("Failed to parse end time: $endTime");
    }
    $end24Hour = $endDateTime->format('H'); // Get hour in 24-hour format

    // Combine the converted times
    return $start24Hour . ' to ' . $end24Hour;
}

function convert24HourTo12Hour($timeRange) {
    // Split the input string into two parts: start time and end time
    list($start24Hour, $end24Hour) = explode(' to ', $timeRange);

    // Convert start time to 12-hour format with AM/PM
    $startDateTime = DateTime::createFromFormat('H', $start24Hour);
    if (!$startDateTime) {
        throw new Exception("Failed to parse start time: $start24Hour");
    }
    $start12Hour = $startDateTime->format('gA'); // Get hour in 12-hour format with AM/PM

    // Convert end time to 12-hour format with AM/PM
    $endDateTime = DateTime::createFromFormat('H', $end24Hour);
    if (!$endDateTime) {
        throw new Exception("Failed to parse end time: $end24Hour");
    }
    $end12Hour = $endDateTime->format('gA'); // Get hour in 12-hour format with AM/PM

    // Combine the converted times
    return $start12Hour . ' to ' . $end12Hour;
}
?>