<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

include 'db.php';
include 'authorization.php';
include 'functions.php';

// Get the raw POST data
$rawData = file_get_contents('php://input');

// Decode JSON data
$data = json_decode($rawData, true);

if (!$data) {
    echo json_encode(["message" => "Invalid JSON data received"]);
    exit();
}

// Validate required fields
if (empty($data['uID'])) {
    echo json_encode(["message" => "Missing required field: uID"]);
    exit();
}

$uID = $data['uID'];
$sessiontime = $data['sessiontime'];
$date = $data['date'];
$day = $data['day'];

$slot_one = null;
$slot_two = null;
$slot_three = null;

$accepted_one = false;
$accepted_two = false;
$accepted_three = false;

if (isset($sessiontime[0])) {
    $slot_one = $sessiontime[0];
    $accepted_one = 'Yes';
}
if (isset($sessiontime[1])) {
    $slot_two = $sessiontime[1];
    $accepted_two = 'Yes';
}
if (isset($sessiontime[2])) {
    $slot_three = $sessiontime[2];
    $accepted_three = 'Yes';
}

// Prepare the SQL INSERT statement
$query = "INSERT INTO updatesession 
            (uID, slot_one, slot_two, slot_three, session_date, session_day, accepted_one, accepted_two, accepted_three) 
          VALUES 
            (?, ?, ?, ?, STR_TO_DATE(?, '%d-%m-%y'), ?, ?, ?, ?)";

// Using prepared statements for secure insertion
$stmt = $conn->prepare($query);
$stmt->bind_param("isssssss", $uID, $slot_one, $slot_two, $slot_three, $date, $day, $accepted_one, $accepted_two, $accepted_three);

// Execute the statement
if ($stmt->execute()) {
   echo json_encode(["message" => "Available Set Succesfull !"]);
} else {
    echo "Error inserting data: " . $stmt->error;
}

// Close the statement and connection
$stmt->close();
$conn->close();
