<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

include 'db.php';
include 'authorization.php';



// Get the raw POST data
$rawData = file_get_contents('php://input');

// Decode JSON data
$data = json_decode($rawData, true);

if (!$data) {
    echo json_encode(["message" => "Invalid JSON data received"]);
    exit();
}


$uID = isset($data['uID']) ? htmlspecialchars($data['uID'], ENT_QUOTES, 'UTF-8') : null;
$appearedForTest = isset($data['appearedfortest']) ? htmlspecialchars($data['appearedfortest'], ENT_QUOTES, 'UTF-8') : null;
$learnerID = isset($data['learnerID']) ? htmlspecialchars($data['learnerID'], ENT_QUOTES, 'UTF-8') : null;
$sessionSelected = isset($data['sessionSelected']) ? htmlspecialchars($data['sessionSelected'], ENT_QUOTES, 'UTF-8') : null;



// $uID = isset($data['uID']) ? filter_var($data['uID'], FILTER_SANITIZE_STRING) : null;
// $appearedForTest = isset($data['appearedfortest']) ? filter_var($data['appearedfortest'], FILTER_SANITIZE_STRING) : null;
// $learnerID = isset($data['learnerID']) ? filter_var($data['learnerID'], FILTER_SANITIZE_STRING) : null;
// $sessionSelected = isset($data['sessionSelected']) ? filter_var($data['sessionSelected'], FILTER_SANITIZE_STRING) : null;


// Process the sessionSelected array
$sessions = $data['sessionSelected'];


function convertTimeRange($timeRange) {
    // Split the input string into two parts: start time and end time
    list($startTime, $endTime) = explode(' to ', $timeRange);
    
    // Convert start time to 24-hour format
    $startDateTime = DateTime::createFromFormat('gA', $startTime);
    if (!$startDateTime) {
        throw new Exception("Failed to parse start time: $startTime");
    }
    $start24Hour = $startDateTime->format('H'); // Get hour in 24-hour format

    // Convert end time to 24-hour format
    $endDateTime = DateTime::createFromFormat('gA', $endTime);
    if (!$endDateTime) {
        throw new Exception("Failed to parse end time: $endTime");
    }
    $end24Hour = $endDateTime->format('H'); // Get hour in 24-hour format

    // Combine the converted times
    return $start24Hour . ' to ' . $end24Hour;
}


// Example query to insert the data into a table (assuming table structure is set up accordingly)
$query = "INSERT INTO test_results (uID, appeared_for_test, learnerID) VALUES ('$uID', '$appearedForTest', '$learnerID')";

if (mysqli_query($conn, $query)) {
    $testResultID = mysqli_insert_id($conn);

    // Insert each session
    foreach ($sessions as $session) {
        $slotOne1 = $session['slotOne'];
        $slotTwo1 = $session['slotTwo'];
        $slotThree1 = $session['slotThree'];
        $date = $session['date'];
        $day = $session['day'];
    
    try {
    $slotOne = convertTimeRange($slotOne1);
} catch (Exception $e) {
    
}
try {
    $slotTwo = convertTimeRange($slotTwo1);
} catch (Exception $e) {
    
}
try {
    $slotThree = convertTimeRange($slotThree1);
} catch (Exception $e) {
    
}
    
    
    // $slotOne = convertTimeRange($slotOne1);
    // $slotTwo = convertTimeRange($slotTwo1);
    // $slotThree = convertTimeRange($slotThree1);

        $sessionQuery = "INSERT INTO session_details (test_result_id, slot_one, slot_two, slot_three, session_date, session_day,uID,learnerID) VALUES ('$testResultID', '$slotOne', '$slotTwo', '$slotThree', '$date', '$day','$uID','$learnerID')";
        mysqli_query($conn, $sessionQuery);
        
    }

    echo json_encode(["message" => "Success Message"]);
} else {
    echo json_encode(["message" => "Error"]);
}

mysqli_close($conn);
?>
