<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

include 'db.php';
include 'authorization.php';




// Get the raw POST data
$rawData = file_get_contents('php://input');

// Decode JSON data
$data = json_decode($rawData, true);

if (!$data) {
    echo json_encode(["message" => "Invalid JSON data received"]);
    exit();
}


$isLearner = isset($data['isLearner']) ? htmlspecialchars($data['isLearner'], ENT_QUOTES, 'UTF-8') : null;
$isInstructor = isset($data['isInstructor']) ? htmlspecialchars($data['isInstructor'], ENT_QUOTES, 'UTF-8') : null;
$name = isset($data['name']) ? htmlspecialchars($data['name'], ENT_QUOTES, 'UTF-8') : null;
$age = isset($data['age']) ? htmlspecialchars($data['age'], ENT_QUOTES, 'UTF-8') : null;
$gender = isset($data['gender']) ? htmlspecialchars($data['gender'], ENT_QUOTES, 'UTF-8') : null;
$postcode = isset($data['postcode']) ? htmlspecialchars($data['postcode'], ENT_QUOTES, 'UTF-8') : null;
$city = isset($data['city']) ? htmlspecialchars($data['city'], ENT_QUOTES, 'UTF-8') : null;
$mobileno = isset($data['mobileno']) ? htmlspecialchars($data['mobileno'], ENT_QUOTES, 'UTF-8') : null;
$learninglicense = isset($data['learninglicense']) ? htmlspecialchars($data['learninglicense'], ENT_QUOTES, 'UTF-8') : null;
$email = isset($data['email']) ? htmlspecialchars($data['email'], ENT_QUOTES, 'UTF-8') : null;
$password = isset($data['password']) ? htmlspecialchars($data['password'], ENT_QUOTES, 'UTF-8') : null;
$adi = isset($data['adi']) ? htmlspecialchars($data['adi'], ENT_QUOTES, 'UTF-8') : null;
$vehicletype = isset($data['vehicletype']) ? htmlspecialchars($data['vehicletype'], ENT_QUOTES, 'UTF-8') : null;
$takemocktest = isset($data['takemocktest']) ? htmlspecialchars($data['takemocktest'], ENT_QUOTES, 'UTF-8') : null;


// $isLearner = isset($data['isLearner']) ? filter_var($data['isLearner'], FILTER_VALIDATE_BOOLEAN) : null;
// $isInstructor = isset($data['isInstructor']) ? filter_var($data['isInstructor'], FILTER_VALIDATE_BOOLEAN) : null;
// $name = isset($data['name']) ? filter_var($data['name'], FILTER_SANITIZE_STRING) : null;
// $age = isset($data['age']) ? filter_var($data['age'], FILTER_SANITIZE_STRING) : null;
// $gender = isset($data['gender']) ? filter_var($data['gender'], FILTER_SANITIZE_STRING) : null;
// $postcode = isset($data['postcode']) ? filter_var($data['postcode'], FILTER_SANITIZE_STRING) : null;
// $city = isset($data['city']) ? filter_var($data['city'], FILTER_SANITIZE_STRING) : null;
// $mobileno = isset($data['mobileno']) ? filter_var($data['mobileno'], FILTER_SANITIZE_STRING) : null;
// $learninglicense = isset($data['learninglicense']) ? filter_var($data['learninglicense'], FILTER_SANITIZE_STRING) : null;
// $email = isset($data['email']) ? filter_var($data['email'], FILTER_VALIDATE_EMAIL) : null;
// $password = isset($data['password']) ? filter_var($data['password'], FILTER_SANITIZE_STRING) : null;
// $adi = isset($data['adi']) ? filter_var($data['adi'], FILTER_SANITIZE_STRING) : null;
// $vehicletype = isset($data['vehicletype']) ? filter_var($data['vehicletype'], FILTER_SANITIZE_STRING) : null;
// $takemocktest = isset($data['takemocktest']) ? filter_var($data['takemocktest'], FILTER_SANITIZE_STRING) : null;


// Check for mandatory fields
if (!$email) {
    echo json_encode(["message" => "Please enter valid email"]);
    exit();
}
if (!$password) {
    echo json_encode(["message" => "Password is required"]);
    exit();
}

$query="SELECT * FROM users WHERE email='$email'";
if ($conn->query($query) === TRUE) {
    echo json_encode(["message" => "Duplicate Email"]);
     exit();
}

$sql = "INSERT INTO users (isLearner, isInstructor, name, age, gender, postcode, city, mobileno, learninglicense, email, password, adi, vehicletype, takemocktest)
        VALUES ('$isLearner', '$isInstructor', '$name', '$age', '$gender', '$postcode', '$city', '$mobileno', '$learninglicense', '$email', '$password', '$adi', '$vehicletype', '$takemocktest')";

if ($conn->query($sql) === TRUE) {
        echo json_encode(["message" => "User registration successful!", "data" => ["username" => $email, "password" => $password]]);

} else {
    echo json_encode(["error" => "Database Error"]);
}


$conn->close();
?>
