<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

include 'db.php';
include 'authorization.php';

// Get the raw POST data
$rawData = file_get_contents('php://input');

// Decode JSON data
$data = json_decode($rawData, true);

if (!$data) {
    echo json_encode(["message" => "Invalid JSON data received"]);
    exit();
}

$username = isset($data['username']) ? htmlspecialchars($data['username'], ENT_QUOTES, 'UTF-8') : '';
$password = isset($data['password']) ? htmlspecialchars($data['password'], ENT_QUOTES, 'UTF-8') : '';
$isLearner = isset($data['isLearner']) ? htmlspecialchars($data['isLearner'], ENT_QUOTES, 'UTF-8') : '';

if (!$username || !$password) {
    echo json_encode(["message" => "Username and password are required"]);
    exit();
}

$sql = "SELECT uID, name, password, isInstructor, isLearner FROM users WHERE email='$username'";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    if ($password == $row['password']) {
        
        $uID = $row['uID'];
        $name = $row['name'];
        $isInstructor = $row['isInstructor'];
        $isLearner1 = $row['isLearner'];

        if (($isLearner === true || $isLearner === "true") && $isInstructor == '1') {
            echo json_encode(["message" => "Please login with correct UserType"]);
            exit();
        }
        if (($isLearner === false || $isLearner === "false") && $isInstructor != '1') {
            echo json_encode(["message" => "Please login with correct UserType"]);
            exit();
        }

        // Fetch relevant entries based on user type
        if ($isLearner === false || $isLearner === "false") {
            $entriesSql = "SELECT `uID`, `isLearner`, `isInstructor`, `name`, `age`, `gender`, `postcode`, `city`, `mobileno`, `learninglicense`, `email`, `password`, `skillpoints` FROM users WHERE isLearner = true";
        } else {
            $entriesSql = "SELECT `uID`, `isLearner`, `isInstructor`, `name`, `age`, `gender`, `postcode`, `city`, `mobileno`, `email`, `password`, `adi`, `vehicletype`, `takemocktest` FROM users WHERE isInstructor = true";
        }
        $entriesResult = $conn->query($entriesSql);
        $entries = [];
        
        if ($entriesResult->num_rows > 0) {
            while ($entry = $entriesResult->fetch_assoc()) {
                $instructorID = $entry['uID'];

                // Calculate the average rating for each instructor
                if ($isLearner === false || $isLearner === "false") {
                    $entry['sesssiontime'] = null;
                    $entry['level'] = null;
                } else {
                    // Query to fetch all session days for the instructor
                    $query = "SELECT session_day FROM session_details 
                              WHERE STR_TO_DATE(session_date, '%d-%m-%y') >= CURDATE() 
                              AND uID='$instructorID' 
                              AND (accepted_one='Yes' OR accepted_two='Yes' OR accepted_three='Yes')";

                    $result = $conn->query($query);

                    // Initialize an array to hold the session days
                    $availableDays = [];

                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            // Add each session_day to the array
                            $availableDays[] = $row['session_day'];
                        }

                        // Assign the array of available days to the entry
                        $entry['availabledays'] = $availableDays;

                        // Calculate average rating
                        $ratingQuery = "SELECT AVG(rating) AS average_rating FROM rateinstructor WHERE instructorID = '$instructorID'";
                        $ratingResult = $conn->query($ratingQuery);
                        $ratingRow = $ratingResult->fetch_assoc();
                        $entry['rating'] = $ratingRow['average_rating'] ? round($ratingRow['average_rating'], 1) : null;
                    } else {
                        // If no sessions found
                        $entry['rating'] = null;
                        $entry['availabledays'] = [];
                    }
                }

                // Add the processed entry to the entries array
                $entries[] = $entry;
            }
        }

        if ($isLearner === false || $isLearner === "false") {
            $query = "SELECT session_date FROM session_details WHERE STR_TO_DATE(session_date, '%d-%m-%y') = CURDATE() AND (accepted_one='Yes' OR accepted_two='Yes' OR accepted_three='Yes')";
            $result = $conn->query($query);
            $availibility = ($result->num_rows > 0);
            
            $query = "SELECT 
            uID,
            
            CASE 
                WHEN NOW() BETWEEN STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_one, ' to ', 1)), '%d-%m-%y %H')
                                AND STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_one, ' to ', -1)), '%d-%m-%y %H')
                 THEN 'Active'
                ELSE 'Expired'
            END AS Slot_One_Status,
            
            CASE 
                WHEN NOW() BETWEEN STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_one, ' to ', 1)), '%d-%m-%y %H')
                                AND STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_one, ' to ', -1)), '%d-%m-%y %H')
            THEN '0 hours 0 mins'
            ELSE 
                CONCAT(
                    FLOOR(TIMESTAMPDIFF(MINUTE, NOW(), STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_one, ' to ', 1)), '%d-%m-%y %H')) / 60), 
                    ' hours ',
                    MOD(TIMESTAMPDIFF(MINUTE, NOW(), STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_one, ' to ', 1)), '%d-%m-%y %H')), 60),
                    ' mins'
                )
            END AS Slot_One_Time_Difference,
            
            CASE 
                WHEN NOW() BETWEEN STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_two, ' to ', 1)), '%d-%m-%y %H')
                                AND STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_two, ' to ', -1)), '%d-%m-%y %H')
                 THEN 'Active'
                ELSE 'Expired'
            END AS Slot_Two_Status,
            
            CASE 
                WHEN NOW() BETWEEN STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_two, ' to ', 1)), '%d-%m-%y %H')
                                AND STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_two, ' to ', -1)), '%d-%m-%y %H')
            THEN '0 hours 0 mins'
            ELSE 
                CONCAT(
                    FLOOR(TIMESTAMPDIFF(MINUTE, NOW(), STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_two, ' to ', 1)), '%d-%m-%y %H')) / 60), 
                    ' hours ',
                    MOD(TIMESTAMPDIFF(MINUTE, NOW(), STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_two, ' to ', 1)), '%d-%m-%y %H')), 60),
                    ' mins'
                )
            END AS Slot_Two_Time_Difference,
            
            CASE 
                WHEN NOW() BETWEEN STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_three, ' to ', 1)), '%d-%m-%y %H')
                                AND STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_three, ' to ', -1)), '%d-%m-%y %H')
                 THEN 'Active'
                ELSE 'Expired'
            END AS Slot_Three_Status,
            
            CASE 
                WHEN NOW() BETWEEN STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_three, ' to ', 1)), '%d-%m-%y %H')
                                AND STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_three, ' to ', -1)), '%d-%m-%y %H')
            THEN '0 hours 0 mins'
            ELSE 
                CONCAT(
                    FLOOR(TIMESTAMPDIFF(MINUTE, NOW(), STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_three, ' to ', 1)), '%d-%m-%y %H')) / 60), 
                    ' hours ',
                    MOD(TIMESTAMPDIFF(MINUTE, NOW(), STR_TO_DATE(CONCAT(session_date, ' ', SUBSTRING_INDEX(slot_three, ' to ', 1)), '%d-%m-%y %H')), 60),
                    ' mins'
                )
            END AS Slot_Three_Time_Difference
            
            FROM session_details WHERE STR_TO_DATE(session_date, '%d-%m-%y') >= CURDATE() AND uID = $uID";

            $availabilityResult = $conn->query($query);
            $availability = [];

            if ($availabilityResult->num_rows > 0) {
                while ($row = $availabilityResult->fetch_assoc()) {
                    $availability[] = $row;
                }
            }

            // Combine user details with their availability
            $response = [
                'user' => [
                    'username' => $username,
                    'name' => $name,
                    'uID' => $uID,
                    'isInstructor' => $isInstructor,
                    'isLearner' => $isLearner1,
                    'availability' => $availability,
                    'entries' => $entries
                ],
                'availability' => $availibility
            ];
        } else {
            $response = [
                'user' => [
                    'username' => $username,
                    'name' => $name,
                    'uID' => $uID,
                    'isInstructor' => $isInstructor,
                    'isLearner' => $isLearner1,
                    'entries' => $entries
                ]
            ];
        }

        echo json_encode($response);

    } else {
        echo json_encode(["message" => "Invalid password"]);
    }
} else {
    echo json_encode(["message" => "User not found"]);
}
?>
