<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

include 'db.php';
include 'authorization.php';
include 'functions.php';

// Get the raw POST data
$rawData = file_get_contents('php://input');

// Decode JSON data
$data = json_decode($rawData, true);

if (!$data) {
    echo json_encode(["message" => "Invalid JSON data received"]);
    exit();
}

// Validate required fields
if (empty($data['uID'])) {
    echo json_encode(["message" => "Missing required field: uID"]);
    exit();
}

$uID = $data['uID'];
$isLearner = $data['isLearner'];
if($isLearner===false || $isLearner==="false"){
$learnerID = $data['learnerID'];
$query="SELECT skillpoints FROM users WHERE uID='$learnerID'";
    $result=$conn->query($query);
    $row=$result->fetch_assoc();
    $skillpoints=$row['skillpoints'];
}else{
    $query="SELECT skillpoints FROM users WHERE uID='$uID'";
    $result=$conn->query($query);
    $row=$result->fetch_assoc();
    $skillpoints=$row['skillpoints'];
}

if($isLearner===false || $isLearner==="false"){
    $userQuery = "
    SELECT users.uID AS instructID, users.name, users.skillpoints, users.postcode
    FROM users
    WHERE users.uID = ?
";
$stmt = $conn->prepare($userQuery);
$stmt->bind_param("i", $uID);
$stmt->execute();
$userResult = $stmt->get_result()->fetch_assoc();

// Query to fetch session details and questions
$userQuery = "
    SELECT users.uID AS instructID, users.name, users.skillpoints, users.postcode
    FROM users
    WHERE users.uID = ?
";
$stmt = $conn->prepare($userQuery);
$stmt->bind_param("i", $uID);
$stmt->execute();
$userResult = $stmt->get_result()->fetch_assoc();

// Query to fetch session details
$sessionQuery = "
    SELECT session_details.slot_one, session_details.slot_two, session_details.slot_three
    FROM session_details
    WHERE session_details.uID = ?
";
$stmt = $conn->prepare($sessionQuery);
$stmt->bind_param("i", $uID);
$stmt->execute();
$sessionResult = $stmt->get_result()->fetch_assoc();

// Determine session time
// $sessionTime = null;
// if (!empty($sessionResult['slot_one'])) {
//     $sessionTime = $sessionResult['slot_one'];
// } elseif (!empty($sessionResult['slot_two'])) {
//     $sessionTime = $sessionResult['slot_two'];
// } elseif (!empty($sessionResult['slot_three'])) {
//     $sessionTime = $sessionResult['slot_three'];
// }
//  try {
//     $sessionTime = convert24HourTo12Hour($sessionTime);
// } catch (Exception $e) {
// }


// Determine session time
$sessionTime = [];

if (!empty($sessionResult['slot_one'])) {
    $sessionTime[] = $sessionResult['slot_one'];
}
if (!empty($sessionResult['slot_two'])) {
    $sessionTime[] = $sessionResult['slot_two'];
}
if (!empty($sessionResult['slot_three'])) {
    $sessionTime[] = $sessionResult['slot_three'];
}

// try {
//     // Loop through each time slot in the $sessionTime array and convert it
//     $sessionTime = array_map(function($time) {
//         return convert24HourTo12Hour($time);
//     }, $sessionTime);
// } catch (Exception $e) {
//     // Handle exceptions if needed
// }


// Query to fetch all questions


$questionsQuery = "
    SELECT 
        q.id AS quesID, 
        q.title, 
        COALESCE(qu.response, 'Need Improvement') AS response
    FROM 
        questions q
    LEFT JOIN 
        question_update qu 
    ON 
        q.id = qu.quesID AND qu.learnerID = ?
";

// Prepare and execute the query
$stmt = $conn->prepare($questionsQuery);
$stmt->bind_param("i", $learnerID);
$stmt->execute();
$questionsResult = $stmt->get_result();

// Prepare the session response array
$sessionResponse = [];
while ($row = $questionsResult->fetch_assoc()) {
    $sessionResponse[] = [
        "quesID" => $row['quesID'],
        "title" => $row['title'],
        "response" => $row['response']  // If not available, it will be "Need Improvement"
    ];
}



// $questionsQuery = "
//     SELECT id AS quesID, title
//     FROM questions
// ";
// $questionsResult = $conn->query($questionsQuery);

// // Prepare the session response array
// $sessionResponse = [];
// while ($row = $questionsResult->fetch_assoc()) {
//     $sessionResponse[] = [
//         "quesID" => $row['quesID'],
//         "title" => $row['title'],
//         "response" => "Need Improvement"
//     ];
// }

// Prepare the JSON output
$myProgress = [
    "skillpoints" => $skillpoints,
    "sessionresponse" => $sessionResponse,
    // "InstructorsInfo" => [
    //     [
    //         "instructID" => $userResult['instructID'],
    //         "name" => $userResult['name'],
    //         "sessiontime" => $sessionTime,
    //         "postcode" => $userResult['postcode'],
    //         "rating" => "0"
    //     ]
    // ]
];

$responseData = [
                "message" => "Success Message!", 
                "data" => $myProgress
            ];
// Encode the array into JSON format
echo json_encode($responseData);


}else{
    // Query to fetch user and instructor information
    $query="SELECT * FROM session_details WHERE learnerID='$uID'";
    $result=$conn->query($query);
    $row=$result->fetch_assoc();
    $new_uID=$row['uID'];
    $userQuery = "
    SELECT users.uID AS instructID, users.name, users.skillpoints, users.postcode
    FROM users
    WHERE users.uID = ?
";
$stmt = $conn->prepare($userQuery);
$stmt->bind_param("i", $new_uID);
$stmt->execute();
$userResult = $stmt->get_result()->fetch_assoc();

// Query to fetch session details and questions
$userQuery = "
    SELECT users.uID AS instructID, users.name, users.skillpoints, users.postcode
    FROM users
    WHERE users.uID = ?
";
$stmt = $conn->prepare($userQuery);
$stmt->bind_param("i", $new_uID);
$stmt->execute();
$userResult = $stmt->get_result()->fetch_assoc();

// Query to fetch session details
$sessionQuery = "
    SELECT 
        CASE WHEN accepted_one = 'Yes' THEN slot_one END AS slot_one,
        CASE WHEN accepted_two = 'Yes' THEN slot_two END AS slot_two,
        CASE WHEN accepted_three = 'Yes' THEN slot_three END AS slot_three
    FROM session_details
    WHERE uID = ?
";
$stmt = $conn->prepare($sessionQuery);
$stmt->bind_param("i", $new_uID);
$stmt->execute();
$sessionResult = $stmt->get_result()->fetch_assoc();

// Determine session time
$sessionTime = [];

if (!empty($sessionResult['slot_one'])) {
    $sessionTime[] = $sessionResult['slot_one'];
}
if (!empty($sessionResult['slot_two'])) {
    $sessionTime[] = $sessionResult['slot_two'];
}
if (!empty($sessionResult['slot_three'])) {
    $sessionTime[] = $sessionResult['slot_three'];
}

try {
    // Loop through each time slot in the $sessionTime array and convert it
    $sessionTime = array_map(function($time) {
        return convert24HourTo12Hour($time);
    }, $sessionTime);
} catch (Exception $e) {
    // Handle exceptions if needed
}


$questionsQuery = "
    SELECT 
        q.id AS quesID, 
        q.title, 
        COALESCE(qu.response, 'Need Improvement') AS response
    FROM 
        questions q
    LEFT JOIN 
        question_update qu 
    ON 
        q.id = qu.quesID AND qu.learnerID = ?
";

// Prepare and execute the query
$stmt = $conn->prepare($questionsQuery);
$stmt->bind_param("i", $uID);
$stmt->execute();
$questionsResult = $stmt->get_result();

// Prepare the session response array
$sessionResponse = [];
while ($row = $questionsResult->fetch_assoc()) {
    $sessionResponse[] = [
        "quesID" => $row['quesID'],
        "title" => $row['title'],
        "response" => $row['response']  // If not available, it will be "Need Improvement"
    ];
}

// Prepare the JSON output
$myProgress = [
    "skillpoints" => $skillpoints,
    "sessionresponse" => $sessionResponse,
    "InstructorsInfo" => [
        [
            "instructID" => $userResult['instructID'],
            "name" => $userResult['name'],
            "sessiontime" => $sessionTime,
            "postcode" => $userResult['postcode'],
            "rating" => "0"
        ]
    ]
];

$responseData = [
                "message" => "Success Message!", 
                "data" => $myProgress
            ];
// Encode the array into JSON format
echo json_encode($responseData);
    
}
$conn->close();